/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.config;

import dev.ftb.mods.ftbessentials.config.PermissionBasedIntValue;
import dev.ftb.mods.ftbessentials.config.TimedCommandConfig;
import dev.ftb.mods.ftbessentials.config.ToggleableConfig;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;

public interface FTBEConfig {
    public static final SNBTConfig CONFIG = (SNBTConfig)SNBTConfig.create((String)"ftbessentials").comment(new String[]{"FTB Essentials config file", "If you're a modpack maker, edit defaultconfigs/ftbessentials-server.snbt instead"});
    public static final SNBTConfig TELEPORTATION = (SNBTConfig)CONFIG.getGroup("teleportation").comment(new String[]{"Teleportation-related settings"});
    public static final TimedCommandConfig BACK = new TimedCommandConfig(TELEPORTATION, "back", 30, 0).comment("Allows users to return to their previous location after teleporting (or dying)");
    public static final PermissionBasedIntValue MAX_BACK = new PermissionBasedIntValue((IntValue)FTBEConfig.BACK.config.getInt("max", 10).range((Number)0, (Number)Integer.MAX_VALUE), "ftbessentials.back.max", "Max size of the teleport history. This limits how many times you can use /back");
    public static final TimedCommandConfig SPAWN = new TimedCommandConfig(TELEPORTATION, "spawn", 10, 0);
    public static final TimedCommandConfig WARP = new TimedCommandConfig(TELEPORTATION, "warp", 10, 0).comment("Allows admins to create 'warps', which are fixed points in the world that users may teleport to using /warp");
    public static final TimedCommandConfig HOME = new TimedCommandConfig(TELEPORTATION, "home", 10, 0).comment("Allows users to set 'homes', which they can then freely teleport to by using /home afterwards");
    public static final PermissionBasedIntValue MAX_HOMES = new PermissionBasedIntValue((IntValue)FTBEConfig.HOME.config.getInt("max", 1).range((Number)0, (Number)Integer.MAX_VALUE), "ftbessentials.home.max", "Max amount of homes a user can have.");
    public static final TimedCommandConfig TPA = new TimedCommandConfig(TELEPORTATION, "tpa", 10, 0).comment("Allows players to create requests to teleport to other users on the server,", "as well as requesting other players to teleport to them");
    public static final TimedCommandConfig RTP = new TimedCommandConfig(TELEPORTATION, "rtp", 600, 0).comment("Allows players to teleport to a random point in the Wilderness", "Note: This currently does not respect Claimed Chunks yet!");
    public static final IntValue RTP_MAX_TRIES = (IntValue)FTBEConfig.RTP.config.getInt("max_tries", 100).range((Number)1, (Number)1000).comment(new String[]{"Number of tries before /rtp gives up"});
    public static final IntValue RTP_MIN_DISTANCE = (IntValue)FTBEConfig.RTP.config.getInt("min_distance", 500).range((Number)0, (Number)30000000).comment(new String[]{"/rtp min distance from spawn point"});
    public static final IntValue RTP_MAX_DISTANCE = (IntValue)FTBEConfig.RTP.config.getInt("max_distance", 25000).range((Number)0, (Number)30000000).comment(new String[]{"/rtp max distance from spawn point"});
    public static final ToggleableConfig TPL = new ToggleableConfig(TELEPORTATION, "tpl").comment("Allows admins to teleport to the location a user was last seen at");
    public static final ToggleableConfig TPX = new ToggleableConfig(TELEPORTATION, "tpx").comment("Allows admins to teleport to dimension");
    public static final SNBTConfig ADMIN = (SNBTConfig)CONFIG.getGroup("admin").comment(new String[]{"Admin commands for cheating and moderation"});
    public static final ToggleableConfig HEAL = new ToggleableConfig(ADMIN, "heal").comment("Allows admins to heal themselves using a command");
    public static final ToggleableConfig FLY = new ToggleableConfig(ADMIN, "fly").comment("Allows admins to toggle flying status using a command, without having to use Creative Mode");
    public static final ToggleableConfig GOD = new ToggleableConfig(ADMIN, "god").comment("Allows admins to toggle invincibility using a command, without having to use Creative Mode");
    public static final ToggleableConfig INVSEE = new ToggleableConfig(ADMIN, "invsee").comment("Allows admins to view other users' inventories using a command");
    public static final ToggleableConfig MUTE = new ToggleableConfig(ADMIN, "mute").comment("Allows admins to restrict players from chatting by using a command to mute (or unmute) them");
    public static final SNBTConfig MISC = (SNBTConfig)CONFIG.getGroup("misc").comment(new String[]{"Miscellaneous features and utilities"});
    public static final ToggleableConfig KICKME = new ToggleableConfig(MISC, "kickme").comment("Allows users to kick themselves from the server, for example if they are stuck or desynced");
    public static final ToggleableConfig TRASHCAN = new ToggleableConfig(MISC, "trashcan").comment("Enables usage of a trash can inventory, which can be used to void unneeded items");
    public static final ToggleableConfig REC = new ToggleableConfig(MISC, "rec").comment("Allows users to announce their recording or streaming status to the server by using commands");
    public static final ToggleableConfig HAT = new ToggleableConfig(MISC, "hat").comment("Allows users to set a custom hat as their head item by using a command");
    public static final ToggleableConfig NICK = new ToggleableConfig(MISC, "nick").comment("Allows users to change their display name, as well as admins to change nicknames for other users");
    public static final ToggleableConfig ENDER_CHEST = new ToggleableConfig(MISC, "enderchest").comment("Allows users to access their ender chest, as well as admins to manage other players' ender chests.");
    public static final ToggleableConfig LEADERBOARD = new ToggleableConfig(MISC, "leaderboard").comment("Allows users to view leaderboard stats about everyone on the server.");
}

